implementation module timerhandle


import	StdList
import	StdTimerDef, receiverhandle, receivertable


::	TimerElementState ls ps									// The internal implementation of a timer
	:==	TimerElementHandle ls ps							// is a TimerElementHandle

::	TimerHandles ps
	=	{	tSysIds	:: [Id]									// The list of free system ids for timers without Id attribute
		,	tTimers	:: [TimerStateHandle ps]				// The timers of a process
//PA---	,	tDoASync:: Bool									// Flag: there are TimerReceivers with non-empty queues
		}
::	TimerStateHandle ps
	=	E..ls: TimerLSHandle (TimerLSHandle ls ps)			// A timer with local state
::	TimerLSHandle ls ps
	=	{	tState	:: ls									// The local state of this timer
		,	tHandle	:: TimerHandle ls ps					// The timer implementation
		}
::	TimerHandle ls ps
	=	{	tId		:: Id									// The Id attribute or generated system Id of the timer
		,	tSelect	:: !Bool								// The TimerSelect==Able (by default True)
		,	tPeriod	:: !Int									// The interval time in ticks
		,	tFun	:: TimerFunction *(ls,ps)				// The TimerFunction, optionally with local state
//PA---	,	tSample	:: Int									// Last time the timer was 'sampled'
//PA---	,	tLS		:: Bool									// The timer has local state (True iff works on local state)
		,	tItems	:: [TimerElementHandle ls ps]			// The elements of the timer
		}
::	TimerElementHandle ls ps
	=	TimerReceiverHandle	(TimerReceiverHandle	ls ps)
	|	TimerListLSHandle	[TimerElementHandle		ls ps]
	|	TimerElimLSHandle	[TimerElementHandle		ls ps]
	|	TimerIntroLSHandle	(TimerIntroLSHandle		ls ps)
	|	TimerExtendLSHandle	(TimerExtendLSHandle	ls ps)
	|	TimerChangeLSHandle	(TimerChangeLSHandle	ls ps)
::	TimerReceiverHandle ls ps
	=	{	tReceiverHandle	:: ReceiverHandle ls ps
		,	tReceiverAtts	:: [TimerAttribute *(ls,ps)]
		}
::	TimerIntroLSHandle	ls ps
	=	E..ls1:
		{	tIntroLS		:: ls1
		,	tIntroItems		:: [TimerElementHandle ls1 ps]
		}
::	TimerExtendLSHandle	ls ps
	=	E..ls1:
		{	tExtendLS		:: ls1
		,	tExtendItems	:: [TimerElementHandle *(ls1,ls) ps]
		}
::	TimerChangeLSHandle	ls ps
	=	E..ls1:
		{	tChangeLS		:: ls1
		,	tChangeItems	:: [TimerElementHandle ls1 ps]
		}


//	Conversion functions from TimerElementState to TimerElementHandle, and vice versa:

TimerElementHandleToTimerElementState :: !(TimerElementHandle .ls .ps) -> TimerElementState .ls .ps
TimerElementHandleToTimerElementState tHs = tHs

TimerElementStateToTimerElementHandle :: !(TimerElementState .ls .ps) -> TimerElementHandle .ls .ps
TimerElementStateToTimerElementHandle tHs = tHs


//	The list of TimerElementHandles contains no 'bound' R(2)Ids. 

noDuplicateTimerReceiverIds :: !SystemId !Id ![TimerElementState .ls .ps] !ReceiverTable
								   -> (!Bool,![TimerElementState .ls .ps],!ReceiverTable)
noDuplicateTimerReceiverIds pid timerid [itemH:itemHs] rt
	# (ok,itemH,rt)	= noDuplicateTimerReceiverIds` pid timerid itemH rt
	| not ok
	= (ok,[itemH:itemHs],rt)
	# (ok,itemHs,rt)= noDuplicateTimerReceiverIds pid timerid itemHs rt
	= (ok,[itemH:itemHs],rt)
where
	noDuplicateTimerReceiverIds` :: !SystemId !Id !(TimerElementHandle .ls .ps) !ReceiverTable
										-> (!Bool, !TimerElementHandle .ls .ps, !ReceiverTable)
	noDuplicateTimerReceiverIds` pid timerid (TimerReceiverHandle itemH=:{tReceiverHandle=trH}) rt
		# opt_rte			= getReceiverTableEntry rid rt
		| isJust opt_rte
		= (False,TimerReceiverHandle itemH,rt)
		# rl				= {rlIOId=pid,rlDevice=TimerDevice,rlParentId=timerid,rlReceiverId=rid}
		  rte				= {rteLoc=rl,rteSelectState=trH.rSelect,rteASMCount=0}
		  (_,rt)			= addReceiverToReceiverTable rte rt
		= (True,TimerReceiverHandle itemH,rt)
	where
		rid					= trH.rId
	noDuplicateTimerReceiverIds` pid timerid (TimerListLSHandle itemHs) rt
		# (ok,itemHs,rt) = noDuplicateTimerReceiverIds pid timerid itemHs rt
		= (ok,TimerListLSHandle itemHs,rt)
	noDuplicateTimerReceiverIds` pid timerid (TimerElimLSHandle itemHs) rt
		# (ok,itemHs,rt) = noDuplicateTimerReceiverIds pid timerid itemHs rt
		= (ok,TimerElimLSHandle itemHs,rt)
	noDuplicateTimerReceiverIds` pid timerid (TimerIntroLSHandle tInH=:{tIntroItems}) rt
		# (ok,itemHs,rt) = noDuplicateTimerReceiverIds pid timerid tIntroItems rt
		= (ok,TimerIntroLSHandle {tInH & tIntroItems=itemHs},rt)
	noDuplicateTimerReceiverIds` pid timerid (TimerExtendLSHandle tExH=:{tExtendItems}) rt
		# (ok,itemHs,rt) = noDuplicateTimerReceiverIds pid timerid tExtendItems rt
		= (ok,TimerExtendLSHandle {tExH & tExtendItems=itemHs},rt)
	noDuplicateTimerReceiverIds` pid timerid (TimerChangeLSHandle tChH=:{tChangeItems}) rt
		# (ok,itemHs,rt) = noDuplicateTimerReceiverIds pid timerid tChangeItems rt
		= (ok,TimerChangeLSHandle {tChH & tChangeItems=itemHs},rt)
noDuplicateTimerReceiverIds _ _ itemHs rt
	= (True,itemHs,rt)
